#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BusinessObjectSortedHashList : BaseTest 
	{
		private class MockBusinessObject : IRecognizableByID
		{
			public readonly int ObjValue;

			public MockBusinessObject( int objValue )
			{
				ObjValue = objValue;
			}

			public object GetObjectID()
			{
				return ObjValue;
			}
		}

		private class MockComparer : BusinessObjectPropertyComparerBase
		{
			protected override int CompareProperties( object x, object y )
			{
				return Comparer.DefaultInvariant.Compare( ((MockBusinessObject)x).ObjValue, ((MockBusinessObject)y).ObjValue );
			}
		}

		private const int TestInitialCapacity = 10;
		private const int TestMockValue = 100;
		
		private BusinessObjectSortedHashList _testList;
		private MockBusinessObject _testObject;		

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			_testList = new BusinessObjectSortedHashList( new MockComparer() );
			_testObject = new MockBusinessObject( TestMockValue );
		}

		[TearDown]
		protected void TearDown()
		{
			_testList = null;
			_testObject = null;
		}

		[Test]
		public void Ctor_SingleParameter_Pass()
		{
			_testList = new BusinessObjectSortedHashList( new MockComparer() );

			AssertConstructorOnTestList();
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void Ctor_SingleParameter_Fail()
		{
			_testList = new BusinessObjectSortedHashList( null );
		}

		[Test]
		public void Ctor_TwoParameter_Pass()
		{
			_testList = new BusinessObjectSortedHashList( new MockComparer(), TestInitialCapacity );
			
			AssertConstructorOnTestList();
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void Ctor_TwoParameter_Fail_1()
		{
			_testList = new BusinessObjectSortedHashList( null, TestInitialCapacity );
		}

		[Test]
		[ExpectedException(typeof(ArgumentOutOfRangeException))]
		public void Ctor_TwoParameter_Fail_2()
		{
			_testList = new BusinessObjectSortedHashList( new MockComparer(), -10 );
		}

		[Test]
		public void Add_Pass()
		{
			Assert.AreEqual( _testObject, _testList.Add( _testObject ) );
			Assert.AreEqual( 1, _testList.Count );
			
			IEnumerator _en = _testList.GetEnumerator();
			_en.MoveNext();
			Assert.AreEqual( _testObject, _en.Current );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void Add_Fail()
		{
			_testList.Add( null );
		}

		[Test]
		public void GetByObjectID_Pass_1()
		{
			AddTestObjectToTestList();
			Assert.AreEqual( _testObject, _testList.GetByObjectID( TestMockValue ) );
		}

		[Test]
		public void GetByObjectID_Pass_2()
		{
			AddTestObjectToTestList();
			Assert.AreEqual( null, _testList.GetByObjectID( TestMockValue * TestMockValue ) );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetByObjectID_Fail()
		{
			_testList.GetByObjectID( null );
		}

		[Test]
		public void GetEnumerator_Pass()
		{
			AddTestObjectToTestList();

			IEnumerator _en = _testList.GetEnumerator();

			Assert.IsNotNull( _en );

			_en.MoveNext();

			Assert.IsNotNull( _en.Current );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetEnumerator_Fail() {}

		[Test]
		public void Count_Pass()
		{
			Assert.AreEqual( 0, _testList.Count );

			AddTestObjectToTestList();

			Assert.AreEqual( 1, _testList.Count );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Count_Fail() {}

		[Test]
		public void SyncRoot_Pass()
		{
			Assert.IsNotNull( _testList.SyncRoot );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void SyncRoot_Fail() {}

		[Test]
		public void IsSynchronized_Pass()
		{
			Assert.IsTrue( !_testList.IsSynchronized );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IsSynchronized_Fail() {}

		[Test]
		public void CopyTo_Pass_1()
		{
			MockBusinessObject[] _ar = new MockBusinessObject[1];

			AddTestObjectToTestList();

			_testList.CopyTo( _ar, 0 );

			Assert.AreEqual( _testObject, _ar[0] );
		}

		[Test]
		public void CopyTo_Pass_2()
		{
			MockBusinessObject[] _ar = new MockBusinessObject[1];

			_testList.CopyTo( _ar, 0 );

			Assert.AreEqual( null, _ar[0] );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void CopyTo_Fail_1()
		{
			_testList.CopyTo( null, 0 );
		}

		[Test]
		[ExpectedException(typeof(ArgumentOutOfRangeException))]
		public void CopyTo_Fail_2()
		{
			_testList.CopyTo( new MockBusinessObject[1], -1 );
		}

		private void AddTestObjectToTestList()
		{
			_testList.Add( _testObject );
		}

		private void AssertConstructorOnTestList()
		{
			Assert.IsNotNull( _testList );
			Assert.AreEqual( 0, _testList.Count );
		}
	}
}

#endif
